/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros;

import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionBlockParser;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.ext.macros.internal.MacrosInlineParserExtension;
import com.vladsch.flexmark.ext.macros.internal.MacrosNodeFormatter;
import com.vladsch.flexmark.ext.macros.internal.MacrosNodeRenderer;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import org.jetbrains.annotations.NotNull;

public class MacrosExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Parser.ReferenceHoldingExtension,
Formatter.FormatterExtension {
    public static final DataKey<KeepType> MACRO_DEFINITIONS_KEEP = new DataKey<KeepType>("MACRO_DEFINITIONS_KEEP", KeepType.FIRST);
    public static final DataKey<MacroDefinitionRepository> MACRO_DEFINITIONS = new DataKey<MacroDefinitionRepository>("MACRO_DEFINITIONS", new MacroDefinitionRepository(null), MacroDefinitionRepository::new);
    public static final DataKey<ElementPlacement> MACRO_DEFINITIONS_PLACEMENT = new DataKey<ElementPlacement>("MACRO_DEFINITIONS_PLACEMENT", ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> MACRO_DEFINITIONS_SORT = new DataKey<ElementPlacementSort>("MACRO_DEFINITIONS_SORT", ElementPlacementSort.AS_IS);
    public static final DataKey<Boolean> SOURCE_WRAP_MACRO_REFERENCES = new DataKey<Boolean>("SOURCE_WRAP_MACRO_REFERENCES", false);

    private MacrosExtension() {
    }

    public static MacrosExtension create() {
        return new MacrosExtension();
    }

    @Override
    public void rendererOptions(@NotNull MutableDataHolder options) {
    }

    @Override
    public void parserOptions(MutableDataHolder options) {
    }

    @Override
    public boolean transferReferences(MutableDataHolder document, DataHolder included) {
        if (included.contains(MACRO_DEFINITIONS)) {
            return Parser.transferReferences(MACRO_DEFINITIONS.get(document), MACRO_DEFINITIONS.get(included), MACRO_DEFINITIONS_KEEP.get(document) == KeepType.FIRST);
        }
        return false;
    }

    @Override
    public void extend(Formatter.Builder formatterBuilder) {
        formatterBuilder.nodeFormatterFactory(new MacrosNodeFormatter.Factory());
    }

    @Override
    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.customBlockParserFactory(new MacroDefinitionBlockParser.Factory());
        parserBuilder.customInlineParserExtensionFactory(new MacrosInlineParserExtension.Factory());
    }

    @Override
    public void extend(@NotNull HtmlRenderer.Builder htmlRendererBuilder, @NotNull String rendererType) {
        if (htmlRendererBuilder.isRendererType("HTML")) {
            htmlRendererBuilder.nodeRendererFactory(new MacrosNodeRenderer.Factory());
        } else if (htmlRendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }
}

