/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.script;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaMessageReporter;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.startup.QodanaRunContextFactory;
import org.jetbrains.qodana.staticAnalysis.script.QodanaScript;
import org.jetbrains.qodana.staticAnalysis.script.QodanaScriptFactory;
import org.jetbrains.qodana.staticAnalysis.script.TeamcityChangeStatus;
import org.jetbrains.qodana.staticAnalysis.script.TeamcityChangesRecord;
import org.jetbrains.qodana.staticAnalysis.script.TeamcityRunContextFactory;
import org.jetbrains.qodana.staticAnalysis.script.TeamcityScript;
import org.jetbrains.qodana.staticAnalysis.script.UnvalidatedParameters;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/script/TeamCityChangesScriptFactory;", "Lorg/jetbrains/qodana/staticAnalysis/script/QodanaScriptFactory;", "<init>", "()V", "scriptName", "", "getScriptName", "()Ljava/lang/String;", "parseParameters", "", "parameters", "createScript", "Lorg/jetbrains/qodana/staticAnalysis/script/QodanaScript;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "messageReporter", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaMessageReporter;", "contextFactory", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/startup/QodanaRunContextFactory;", "Lorg/jetbrains/qodana/staticAnalysis/script/UnvalidatedParameters;", "parseChangesFile", "", "Lorg/jetbrains/qodana/staticAnalysis/script/TeamcityChangesRecord;", "changesPath", "parseLine", "line", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nteamcity-changes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 teamcity-changes.kt\norg/jetbrains/qodana/staticAnalysis/script/TeamCityChangesScriptFactory\n+ 2 UnvalidatedParameters.kt\norg/jetbrains/qodana/staticAnalysis/script/UnvalidatedParametersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n41#2:96\n1563#3:97\n1634#3,3:98\n*S KotlinDebug\n*F\n+ 1 teamcity-changes.kt\norg/jetbrains/qodana/staticAnalysis/script/TeamCityChangesScriptFactory\n*L\n33#1:96\n43#1:97\n43#1:98,3\n*E\n"})
public final class TeamCityChangesScriptFactory
implements QodanaScriptFactory {
    @NotNull
    private final String scriptName;

    public TeamCityChangesScriptFactory() {
        this.scriptName = "teamcity-changes";
    }

    @Override
    @NotNull
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    @NotNull
    public Map<String, String> parseParameters(@NotNull String parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return ((CharSequence)parameters).length() == 0 ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)parameters));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public QodanaScript createScript(@NotNull QodanaConfig config, @NotNull QodanaMessageReporter messageReporter, @NotNull QodanaRunContextFactory contextFactory, @NotNull UnvalidatedParameters parameters) {
        void $this$optional$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)messageReporter, (String)"messageReporter");
        Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        UnvalidatedParameters unvalidatedParameters = parameters;
        String name$iv = "path";
        boolean $i$f$optional = false;
        String string = (String)$this$optional$iv.optional(name$iv, Reflection.getOrCreateKotlinClass(String.class));
        if (string == null) {
            string = "teamcity-changes.txt";
        }
        String path = string;
        List<TeamcityChangesRecord> changes = this.parseChangesFile(path, config);
        return new TeamcityScript(new TeamcityRunContextFactory(contextFactory, changes));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TeamcityChangesRecord> parseChangesFile(String changesPath, QodanaConfig config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path path = Paths.get(changesPath, new String[0]);
        Path effectivePath = path.isAbsolute() ? path : config.getProjectPath().resolve(path);
        Intrinsics.checkNotNull((Object)effectivePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(effectivePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object[] objectArray = new Object[]{((Object)effectivePath.toAbsolutePath()).toString()};
            String string = QodanaBundle.message("teamcity.changes.file.is.absent", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new QodanaException(string);
        }
        Iterable<Path> iterable = effectivePath;
        List<String> list2 = Files.readAllLines(iterable, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
        iterable = list2;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.parseLine((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final TeamcityChangesRecord parseLine(String line) {
        TeamcityChangeStatus teamcityChangeStatus;
        String[] stringArray = new String[]{":"};
        List split = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() != 3) {
            Object[] objectArray = new Object[]{line};
            String string = QodanaBundle.message("wrong.teamcity.changes.file.line.format", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new QodanaException(string);
        }
        try {
            teamcityChangeStatus = TeamcityChangeStatus.valueOf((String)split.get(1));
        }
        catch (IllegalArgumentException ignored) {
            Object[] objectArray = new Object[]{line};
            String string = QodanaBundle.message("wrong.teamcity.changes.file.line.format", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new QodanaException(string);
        }
        TeamcityChangeStatus status2 = teamcityChangeStatus;
        return new TeamcityChangesRecord((String)split.get(0), status2, (String)split.get(2));
    }
}

