/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.PyUserTypeRenderer;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.ClientModeDebuggerStatusHolder;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.ProcessCreatedMsgReceivedCommand;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandBuilder;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandResult;
import com.jetbrains.python.tables.TableCommandParameters;
import com.jetbrains.python.tables.TableCommandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientModeMultiProcessDebugger
implements ProcessDebugger {
    private static final Logger LOG = Logger.getInstance(ClientModeMultiProcessDebugger.class);
    private final IPyDebugProcess myDebugProcess;
    @NotNull
    private final String myHost;
    private final int myPort;
    private final Object myDebuggersObject;
    private final List<RemoteDebugger> myDebuggers;
    private final ThreadRegistry myThreadRegistry;
    private final ClientModeDebuggerStatusHolder myDebuggerStatusHolder;
    private final CompositeRemoteDebuggerCloseListener myCompositeListener;
    @NotNull
    private final ExecutorService myExecutor;

    public ClientModeMultiProcessDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull String host, int port) {
        if (debugProcess == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(0);
        }
        if (host == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(1);
        }
        this.myDebuggersObject = new Object();
        this.myDebuggers = new ArrayList<RemoteDebugger>();
        this.myThreadRegistry = new ThreadRegistry();
        this.myDebuggerStatusHolder = new ClientModeDebuggerStatusHolder();
        this.myCompositeListener = new CompositeRemoteDebuggerCloseListener();
        this.myDebugProcess = debugProcess;
        this.myHost = host;
        this.myPort = port;
        String connectionThreadsName = "Debugger connection thread (" + host + ":" + port + ")";
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)connectionThreadsName);
        this.myExecutor.execute(new ConnectToDebuggerTask());
    }

    private void tryToConnectRemoteDebugger() throws Exception {
        RemoteDebugger debugger = new RemoteDebugger(this.myDebugProcess, this.myHost, this.myPort){

            @Override
            protected void onProcessCreatedEvent(int commandSequence) {
                try {
                    ProcessCreatedMsgReceivedCommand command = new ProcessCreatedMsgReceivedCommand(this, commandSequence);
                    command.execute();
                    ClientModeMultiProcessDebugger.this.myExecutor.execute(new ConnectToDebuggerTask());
                }
                catch (PyDebuggerException e) {
                    LOG.info((Throwable)e);
                }
            }
        };
        debugger.waitForConnect();
        this.onRemoteDebuggerConnected(debugger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRemoteDebuggerConnected(@NotNull RemoteDebugger debugger) {
        if (debugger == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(2);
        }
        Object object = this.myDebuggersObject;
        synchronized (object) {
            this.myDebuggers.add(debugger);
        }
        if (this.myDebuggerStatusHolder.onConnected()) {
            debugger.addCloseListener(this.myCompositeListener);
        } else {
            this.myDebugProcess.init();
            try {
                debugger.run();
            }
            catch (PyDebuggerException e) {
                LOG.debug("Failed to `CMD_RUN` the recently connected Python debugger process");
            }
        }
    }

    @Override
    public boolean isConnected() {
        return ContainerUtil.exists(this.allDebuggers(), RemoteDebugger::isConnected);
    }

    @Override
    public void waitForConnect() throws Exception {
        Thread.sleep(500L);
        this.myDebuggerStatusHolder.onConnecting();
        if (!this.myDebuggerStatusHolder.awaitWhileConnecting()) {
            throw new PyDebuggerException("The process terminated before IDE established connection with Python debugger script");
        }
    }

    @Override
    public void close() {
        this.myDebuggerStatusHolder.onDisconnectionInitiated();
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RemoteDebugger> allDebuggers() {
        Object object = this.myDebuggersObject;
        synchronized (object) {
            return new ArrayList<RemoteDebugger>(this.myDebuggers);
        }
    }

    @Override
    public void disconnect() {
        this.myDebuggerStatusHolder.onDisconnectionInitiated();
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.disconnect();
        }
    }

    @Override
    public String handshake() throws PyDebuggerException {
        Object object = this.myDebuggersObject;
        synchronized (object) {
            if (!this.myDebuggers.isEmpty()) {
                return this.myDebuggers.get(0).handshake();
            }
            throw new IllegalStateException("waitForConnect() must be executed before handshake()");
        }
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2, int evaluationTimeout) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2, evaluationTimeout);
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2, int evaluationTimeout, boolean trimResult) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2, evaluationTimeout, trimResult);
    }

    @Override
    public void consoleExec(String threadId, String frameId, String expression, PyDebugCallback<String> callback) {
        this.debugger(threadId).consoleExec(threadId, frameId, expression, callback);
    }

    @Override
    public XValueChildrenList loadFrame(String threadId, String frameId, ProcessDebugger.GROUP_TYPE groupType) throws PyDebuggerException {
        return this.debugger(threadId).loadFrame(threadId, frameId, groupType);
    }

    @Override
    @Nullable
    public String execTableCommand(String threadId, String frameId, String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        return this.debugger(threadId).execTableCommand(threadId, frameId, command, commandType, tableCommandParameters);
    }

    @Override
    @Nullable
    public String execTableImageCommand(String threadId, String frameId, String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        return this.debugger(threadId).execTableCommand(threadId, frameId, command, commandType, tableCommandParameters);
    }

    @Override
    public List<Pair<String, Boolean>> getSmartStepIntoVariants(String threadId, String frameId, int startContextLine, int endContextLine) throws PyDebuggerException {
        return this.debugger(threadId).getSmartStepIntoVariants(threadId, frameId, startContextLine, endContextLine);
    }

    @Override
    public XValueChildrenList loadVariable(String threadId, String frameId, PyDebugValue var) throws PyDebuggerException {
        return this.debugger(threadId).loadVariable(threadId, frameId, var);
    }

    @Override
    public ArrayChunk loadArrayItems(String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        return this.debugger(threadId).loadArrayItems(threadId, frameId, var, rowOffset, colOffset, rows, cols, format);
    }

    @Override
    @NotNull
    public DataViewerCommandResult executeDataViewerCommand(@NotNull DataViewerCommandBuilder builder) throws PyDebuggerException {
        if (builder == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(3);
        }
        assert (builder.getThreadId() != null);
        DataViewerCommandResult dataViewerCommandResult = this.debugger(builder.getThreadId()).executeDataViewerCommand(builder);
        if (dataViewerCommandResult == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(4);
        }
        return dataViewerCommandResult;
    }

    @Override
    public void loadReferrers(String threadId, String frameId, PyReferringObjectsValue var, PyDebugCallback<? super XValueChildrenList> callback) {
        this.debugger(threadId).loadReferrers(threadId, frameId, var, callback);
    }

    @NotNull
    private ProcessDebugger debugger(@NotNull String threadId) {
        RemoteDebugger debugger;
        if (threadId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(5);
        }
        if ((debugger = this.myThreadRegistry.getDebugger(threadId)) != null) {
            RemoteDebugger remoteDebugger = debugger;
            if (remoteDebugger == null) {
                ClientModeMultiProcessDebugger.$$$reportNull$$$0(6);
            }
            return remoteDebugger;
        }
        ArrayList<RemoteDebugger> debuggers = this.getDebuggers();
        for (ProcessDebugger processDebugger : debuggers) {
            for (PyThreadInfo thread : processDebugger.getThreads()) {
                if (!threadId.equals(thread.getId())) continue;
                ProcessDebugger processDebugger2 = processDebugger;
                if (processDebugger2 == null) {
                    ClientModeMultiProcessDebugger.$$$reportNull$$$0(7);
                }
                return processDebugger2;
            }
        }
        ProcessDebugger processDebugger = (ProcessDebugger)debuggers.get(0);
        if (processDebugger == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(8);
        }
        return processDebugger;
    }

    @Override
    public PyDebugValue changeVariable(String threadId, String frameId, PyDebugValue var, String value) throws PyDebuggerException {
        return this.debugger(threadId).changeVariable(threadId, frameId, var, value);
    }

    @Override
    public void loadFullVariableValues(@NotNull String threadId, @NotNull String frameId, @NotNull List<PyFrameAccessor.PyAsyncValue<String>> vars) throws PyDebuggerException {
        if (threadId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(9);
        }
        if (frameId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(10);
        }
        if (vars == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(11);
        }
        this.debugger(threadId).loadFullVariableValues(threadId, frameId, vars);
    }

    @Override
    public String loadSource(String path2) {
        Object object = this.myDebuggersObject;
        synchronized (object) {
            if (!this.myDebuggers.isEmpty()) {
                return this.myDebuggers.get(0).loadSource(path2);
            }
            throw new IllegalStateException("waitForConnect() must be executed before loadSource()");
        }
    }

    @Override
    public Collection<PyThreadInfo> getThreads() {
        this.cleanDebuggers();
        List<PyThreadInfo> threads = this.collectAllThreads();
        if (!this.isDebuggersEmpty()) {
            return Collections.unmodifiableCollection(Collections2.transform(threads, t -> {
                if (t == null) {
                    return null;
                }
                String threadName = ThreadRegistry.threadName(t.getName(), t.getId());
                PyThreadInfo newThread = new PyThreadInfo(t.getId(), threadName, t.getFrames(), t.getStopReason(), t.getMessage());
                newThread.updateState(t.getState(), t.getFrames());
                return newThread;
            }));
        }
        return Collections.unmodifiableCollection(threads);
    }

    private List<PyThreadInfo> collectAllThreads() {
        ArrayList<PyThreadInfo> result2 = new ArrayList<PyThreadInfo>();
        for (RemoteDebugger d : this.myDebuggers) {
            result2.addAll(d.getThreads());
            for (PyThreadInfo t : d.getThreads()) {
                this.myThreadRegistry.register(t.getId(), d);
            }
        }
        return result2;
    }

    private void cleanDebuggers() {
        this.removeDisconnected(this.getDebuggers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisconnected(ArrayList<RemoteDebugger> debuggers) {
        boolean allConnected = true;
        for (RemoteDebugger d : debuggers) {
            if (d.isConnected()) continue;
            allConnected = false;
        }
        if (!allConnected) {
            ArrayList<RemoteDebugger> newList = new ArrayList<RemoteDebugger>();
            for (RemoteDebugger d : debuggers) {
                if (!d.isConnected()) continue;
                newList.add(d);
            }
            Object object = this.myDebuggersObject;
            synchronized (object) {
                this.myDebuggers.clear();
                this.myDebuggers.addAll(newList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<RemoteDebugger> getDebuggers() {
        Object object = this.myDebuggersObject;
        synchronized (object) {
            return Lists.newArrayList(this.myDebuggers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDebuggersEmpty() {
        Object object = this.myDebuggersObject;
        synchronized (object) {
            return this.myDebuggers.isEmpty();
        }
    }

    @Override
    public void execute(@NotNull AbstractCommand command) {
        if (command == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(12);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.execute(command);
        }
    }

    @Override
    public void suspendAllThreads() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.suspendAllThreads();
        }
    }

    @Override
    public void suspendThread(String threadId) {
        this.debugger(threadId).suspendThread(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws PyDebuggerException {
        Object object = this.myDebuggersObject;
        synchronized (object) {
            if (this.myDebuggers.isEmpty()) {
                throw new IllegalStateException("waitForConnect() must be executed before run()");
            }
            this.myDebuggers.get(0).run();
        }
    }

    @Override
    public void smartStepInto(String threadId, String frameId, String functionName, int callOrder, int contextStartLine, int contextEndLine) {
        this.debugger(threadId).smartStepInto(threadId, frameId, functionName, callOrder, contextStartLine, contextEndLine);
    }

    @Override
    public void resumeOrStep(String threadId, ResumeOrStepCommand.Mode mode) {
        this.debugger(threadId).resumeOrStep(threadId, mode);
    }

    @Override
    public void setNextStatement(@NotNull String threadId, @NotNull XSourcePosition sourcePosition, @Nullable String functionName, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (threadId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(13);
        }
        if (sourcePosition == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(14);
        }
        if (callback == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(15);
        }
        this.debugger(threadId).setNextStatement(threadId, sourcePosition, functionName, callback);
    }

    @Override
    public void setTempBreakpoint(@NotNull String type2, @NotNull String file, int line) {
        if (type2 == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(16);
        }
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(17);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setTempBreakpoint(type2, file, line);
        }
    }

    @Override
    public void removeTempBreakpoint(@NotNull String file, int line) {
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(18);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.removeTempBreakpoint(file, line);
        }
    }

    @Override
    public void setBreakpoint(@NotNull String typeId, @NotNull String file, int line, @Nullable String condition, @Nullable String logExpression, @Nullable String funcName, @NotNull SuspendPolicy policy) {
        if (typeId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(19);
        }
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(20);
        }
        if (policy == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(21);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setBreakpoint(typeId, file, line, condition, logExpression, funcName, policy);
        }
    }

    @Override
    public void removeBreakpoint(@NotNull String typeId, @NotNull String file, int line) {
        if (typeId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(22);
        }
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(23);
        }
        this.allDebuggers().forEach(d -> d.removeBreakpoint(typeId, file, line));
    }

    @Override
    public void setUserTypeRenderers(@NotNull @NotNull List<@NotNull PyUserTypeRenderer> renderers) {
        if (renderers == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(24);
        }
        this.allDebuggers().forEach(d -> d.setUserTypeRenderers(renderers));
    }

    @Override
    public void setShowReturnValues(boolean isShowReturnValues) {
        this.allDebuggers().forEach(d -> d.setShowReturnValues(isShowReturnValues));
    }

    @Override
    public void setUnitTestDebuggingMode() {
        this.allDebuggers().forEach(d -> d.setUnitTestDebuggingMode());
    }

    @Override
    public void addCloseListener(RemoteDebuggerCloseListener listener2) {
        this.myCompositeListener.addCloseListener(listener2);
    }

    @Override
    public List<PydevCompletionVariant> getCompletions(String threadId, String frameId, String prefix) {
        return this.debugger(threadId).getCompletions(threadId, frameId, prefix);
    }

    @Override
    public String getDescription(String threadId, String frameId, String cmd) {
        return this.debugger(threadId).getDescription(threadId, frameId, cmd);
    }

    @Override
    public void addExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createAddCommand(d));
        }
    }

    @Override
    public void removeExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createRemoveCommand(d));
        }
    }

    @Override
    public void suspendOtherThreads(PyThreadInfo thread) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.suspendOtherThreads(thread);
        }
    }

    @Override
    public void interruptDebugConsole() {
        for (RemoteDebugger debugger : this.myDebuggers) {
            debugger.interruptDebugConsole();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/ClientModeMultiProcessDebugger";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/ClientModeMultiProcessDebugger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executeDataViewerCommand";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "debugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onRemoteDebuggerConnected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeDataViewerCommand";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "debugger";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadFullVariableValues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setNextStatement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setTempBreakpoint";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeTempBreakpoint";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpoint";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setUserTypeRenderers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class ThreadRegistry {
        private final Map<String, RemoteDebugger> myThreadIdToDebugger = Maps.newHashMap();

        private ThreadRegistry() {
        }

        public void register(String id, RemoteDebugger debugger) {
            this.myThreadIdToDebugger.put(id, debugger);
        }

        public RemoteDebugger getDebugger(String threadId) {
            return this.myThreadIdToDebugger.get(threadId);
        }

        public static String threadName(@NotNull String name2, @NotNull String id) {
            int indx;
            if (name2 == null) {
                ThreadRegistry.$$$reportNull$$$0(0);
            }
            if (id == null) {
                ThreadRegistry.$$$reportNull$$$0(1);
            }
            if ((indx = id.indexOf("_", id.indexOf("_") + 1)) != -1) {
                id = id.substring(0, indx);
            }
            return name2 + "(" + id + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/pydev/ClientModeMultiProcessDebugger$ThreadRegistry";
            objectArray[2] = "threadName";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompositeRemoteDebuggerCloseListener
    implements RemoteDebuggerCloseListener {
        private final List<RemoteDebuggerCloseListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private CompositeRemoteDebuggerCloseListener() {
        }

        public void addCloseListener(RemoteDebuggerCloseListener listener2) {
            this.myListeners.add(listener2);
        }

        @Override
        public void closed() {
            this.myListeners.forEach(RemoteDebuggerCloseListener::closed);
        }

        @Override
        public void communicationError() {
            this.myListeners.forEach(RemoteDebuggerCloseListener::communicationError);
        }

        @Override
        public void detached() {
            this.myListeners.forEach(RemoteDebuggerCloseListener::detached);
        }
    }

    private class ConnectToDebuggerTask
    implements Runnable {
        private ConnectToDebuggerTask() {
        }

        @Override
        public void run() {
            try {
                ClientModeMultiProcessDebugger.this.tryToConnectRemoteDebugger();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

